<?PHP 
	if(!$admin_show['application_requests']) { show_error('Forbidden',403); }
	$this->load->view('api/header'); 
	$this->load->view('api/nav');
	$this->load->helper('form');
	$count = 0;
?>
				<div id="success">&nbsp;</div>
				<div id="error">&nbsp;</div>
				<h1 class="administration">Administration</h1>
				<ul class="adminnav" role="menu">
					<li>
						<a role="menuitem" href="/administration/application/requests">Application Requests</a>
						<?PHP if($admin_show['manage_accounts'] || $admin_show['account_requests']) { ?>
						<ul role="menu">
							<?PHP if($admin_show['account_requests']) { ?>
								<li><a role="menuitem" href="/administration/account/requests">Account Requests</a></li>
							<?PHP } ?>
							<?PHP if($admin_show['manage_accounts']) { ?>
								<li><a role="menuitem" href="/administration/manage/accounts">Manage Accounts</a></li>
							<?PHP } ?>
							<?PHP if($admin_show['manage_groups']) { ?>
								<li role="menuitem" ><a href="/administration/manage/groups">Manage Groups</a></li>
							<?PHP } ?>
						</ul>
						<?PHP } ?>
					</li>
				</ul>
				<div class="column">
					<?PHP if(isset($message)) { echo '<div class="message">'.$message.'</div>'; } ?>
					<?PHP if(isset($error_message)) { echo '<div class="message_error">'.$error_message.'</div>'; } ?>
					<?PHP if(isset($success_message)) { echo '<div class="message_success">'.$success_message.'</div>'; } ?>
					<div id="message-success" class="message_success display_none">&nbsp;</div>
					<div id="message-error" class="message_error display_none">&nbsp;</div>
					<script>
						$(function() {
							$("#tabs").tabs();

							$("[id^=dialog-form]").dialog({
								autoOpen: false,
								width: 600,
								height: 300,
								modal: true,
								buttons: {
									Submit: function(){
										var id = $(this).attr('id').replace('dialog-form','');
										$('#denyForm'+id).submit();
									},
									Cancel: function(){
										$(this).dialog("close");
									}
								}
							});
							$("[id^=deny-app]").click(function(e) {
								var id = 0;
								if($(e.target).attr('id')){
									id = $(e.target).attr('id').replace('deny-app',''); 
								}
								else{
									id = $(e.target).parent().attr('id').replace('deny-app',''); //get parent id since click is on image
								}
								$("#dialog-form"+id).dialog("open");
							});
						});
					</script>
					<?PHP
						echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
						$hidden_inputs = array(
							'page_select_correction' => '',
							'prefix' => '',
							'pending_page_on_bar' => '',
							'pending_page_select' => '',
							'pending_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'approved_page_on_bar' => '',
							'approved_page_select' => '',
							'approved_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							'denied_page_on_bar' => '',
							'denied_page_select' => '',
							'denied_items_per_page' => ITEMS_PER_PAGE_DEFAULT,
							
						);
						echo form_hidden($hidden_inputs,TRUE);
						echo form_close();
					?>
					<div id="tabs" class="column">
						<ul>
							<li><a id="pending_link" href="#pending">Pending Approval</a></li>
							<li><a id="approved_link" href="#approved">Approved</a></li>
							<li><a id="denied_link" href="#denied">Denied</a></li>
						</ul>
						<div id="pending">
							<p>This table lists the applications that are awaiting approval for access to the API services.</p>						
							<?php if (sizeof($pending_list) == 0) { ?>
								<div class="message">There are currently no application requests awaiting approval.</div>
							<?php }else{ ?>
								<?PHP
									echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
									echo $pending_pages->display_pagination_bar();
									echo form_close();
								?>
								<table class="display">
									<tr>
										<th>Application</th>
										<th>POC</th>
										<th>Justification</th>
										<th>Requested Date</th>
										<th class="displaylast">Actions</th>
									</tr>								
									<?php foreach($pending_list as $request){ ?>
										<tr id="<?php echo $request->id; ?>row">
											<td>
												<?php echo $request->name; ?>&nbsp;
												<?php if ($request->url){?>
													<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->description){?>
													<br/><?php echo $request->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
												<?php if ($request->poc_name){?>
													<?php echo $request->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($request->poc_email){?>
													<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->poc_phone){?>
													<br/><?php echo $request->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td><?php echo $request->justification; ?>&nbsp;</td>
											<td><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
											<td>
												<?PHP
													echo form_open('/administration/approve_request',array('id'=>'approveForm'.$request->id,'class'=>'approveForm'));
													$hidden_inputs = array(
														'request_id' => $request->id,
														'pending_page_select_from_approve_button' => $pending_cur_page,
														'pending_items_per_page_from_approve_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														'approved_page_select_from_approve_button' => $approved_cur_page,
														'approved_items_per_page_from_approve_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														'denied_page_select_from_approve_button' => $denied_cur_page,
														'denied_items_per_page_from_approve_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
													);
													echo form_hidden($hidden_inputs,TRUE);
													echo form_close();
												?>
												<div id="dialog-form<?php echo $request->id; ?>" title="Reason for Denial">
													<?PHP
														echo form_open('/administration/deny_request',array('id'=>'denyForm'.$request->id));
														echo form_label('Reason for Denial:','denial_reason'.$request->id,array('class'=>'modal'));
														echo form_textarea('reason','','id="denial_reason'.$request->id.'" class="modal"');
														$hidden_inputs = array(
															'request_id' => $request->id,
															'pending_page_select_from_deny_button' => $pending_cur_page,
															'pending_items_per_page_from_deny_button' => $pending_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
															'approved_page_select_from_deny_button' => $approved_cur_page,
															'approved_items_per_page_from_deny_button' => $approved_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
															'denied_page_select_from_deny_button' => $denied_cur_page,
															'denied_items_per_page_from_deny_button' => $denied_items_per_page ?: ITEMS_PER_PAGE_DEFAULT,
														);
														echo form_hidden($hidden_inputs,TRUE);
														echo form_close();
													?>
												</div>
												<div class="center">
													<a href="#" onclick="if (confirm('Are you sure you want to approve <?php echo $request->name; ?>?')){$('#approveForm<?php echo $request->id; ?>').submit();}" title="Approve Request: <?php echo $request->name; ?>"><img src="/images/icons/accept.png" alt="Approve Request: <?php echo $request->name; ?>" /></a>
													<a href="#" id="deny-app<?php echo $request->id; ?>" title="Deny Request: <?php echo $request->name; ?>"><img src="/images/icons/cancel.png" alt="Deny Request: <?php echo $request->name; ?>" /></a>
												</div>
											</td>
										</tr>
									<?php $count++; } ?>
								</table>
								<?PHP
									echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
									echo $pending_pages->display_pagination_bar();
									echo form_close();
								?>
							<?php } ?>
						</div>
						
						<div id="approved">
							<p>This table lists the applications that have been approved for access to the API services.</p>
							<?php if (sizeof($approved_list) == 0) { ?>
								<div class="message">There are currently no applications that have been approved.</div>
							<?php }else{ ?>
								<?PHP
									echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
									echo $approved_pages->display_pagination_bar();
									echo form_close();
								?>
								<table class="display">
									<tr>
										<th>Application</th>
										<th>POC</th>
										<th>Requested Date</th>
										<th class="displaylast">Approval Date</th>
									</tr>
									<?php foreach($approved_list as $request){ ?>
										<tr id="<?php echo $request->id; ?>row">
											<td>
												<?php echo $request->name; ?>&nbsp;
												<?php if ($request->url){?>
													<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->description){?>
													<br/><?php echo $request->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
												<?php if ($request->poc_name){?>
													<?php echo $request->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($request->poc_email){?>
													<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->poc_phone){?>
													<br/><?php echo $request->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
											<td>
												<?php echo date("M d Y H:i:s",$request->approved_date); ?>&nbsp;
											</td>
										</tr>
									<?php } ?>
								</table>
								<?PHP
									echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
									echo $approved_pages->display_pagination_bar();
									echo form_close();
								?>
							<?php } ?>
						</div>						
						<div id="denied">
							<p>This table lists the applications that have been denied access to the API services.</p>
							<?php if (sizeof($denied_list) == 0) { ?>
								<div class="message">There are currently no application requests that have been denied.</div>
							<?php }else{ ?>
								<?PHP
									echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
									echo $denied_pages->display_pagination_bar();
									echo form_close();
								?>
								<table class="display">
									<tr>
										<th>Application</th>
										<th>POC</th>
										<th>Requested Date</th>
										<th class="displaylast">Denial Reason</th>
									</tr>	
									<?php foreach($denied_list as $request){ ?>
										<tr id="<?php echo $request->id; ?>row">
											<td>
												<?php echo $request->name; ?>&nbsp;
												<?php if ($request->url){?>
													<br/><a target="_blank" href="<?php echo $request->url; ?>"><?php echo $request->url; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->description){?>
													<br/><?php echo $request->description; ?>&nbsp;
												<?php } ?>
											</td>
											<td>
												<?php if ($request->poc_name){?>
													<?php echo $request->poc_name; ?>&nbsp;
												<?php } ?>
												<?php if ($request->poc_email){?>
													<br/><a href="mailto:<?php echo $request->poc_email; ?>"><?php echo $request->poc_email; ?></a>&nbsp;
												<?php } ?>
												<?php if ($request->poc_phone){?>
													<br/><?php echo $request->poc_phone; ?>&nbsp;
												<?php } ?>
											</td>
											<td><?php echo date("M d Y H:i:s",$request->requested_date); ?>&nbsp;</td>
											<td>
												<?php echo $request->denial_reason; ?>&nbsp;
											</td>
										</tr>
									<?php } ?>
								</table>
								<?PHP
									echo form_open('/administration/application/requests',array('id'=>'app_request_form'));
									echo $denied_pages->display_pagination_bar();
									echo form_close();
								?>
							<?php } ?>
						</div>
					</div>
				</div>
			</div>
			<?PHP $this->load->view('api/footer'); ?>
		</div>
	</body>
</html>

<script type='text/javascript'>
	goToSubTab(<?PHP if(isset($anchor)){echo json_encode($anchor);} ?>);
	assignPaginationFormValues(<?PHP echo json_encode($form_values); ?>);
</script>
